<?php
session_start();
require_once 'classes/User.php';

// Check if user is logged in
if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user = new User();
$users = $user->getAllUsers();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="#">User Management System</a>
            <div class="navbar-nav ms-auto">
                <span class="nav-item nav-link text-light">
                    Welcome, <?php echo htmlspecialchars($_SESSION['username']); ?> 
                    (<?php echo ucfirst($_SESSION['user_type']); ?>)
                </span>
                <a class="nav-link" href="logout.php">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <?php if($_SESSION['user_type'] === 'backend'): ?>
            <div class="card">
                <div class="card-header">
                    <h4>User Management</h4>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Username</th>
                                <th>Email</th>
                                <th>User Type</th>
                                <th>Created At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($row = $users->fetch(PDO::FETCH_ASSOC)): ?>
                                <tr>
                                    <td><?php echo $row['id']; ?></td>
                                    <td><?php echo htmlspecialchars($row['username']); ?></td>
                                    <td><?php echo htmlspecialchars($row['email']); ?></td>
                                    <td><?php echo ucfirst($row['user_type']); ?></td>
                                    <td><?php echo $row['created_at']; ?></td>
                                    <td>
                                        <a href="delete_user.php?id=<?php echo $row['id']; ?>" 
                                           class="btn btn-danger btn-sm"
                                           onclick="return confirm('Are you sure you want to delete this user?')">
                                            Delete
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php else: ?>
            <div class="card">
                <div class="card-header">
                    <h4>Frontend Dashboard</h4>
                </div>
                <div class="card-body">
                    <p>Welcome to the frontend dashboard! This area is specifically for frontend users.</p>
                    <p>Your account details:</p>
                    <ul>
                        <li>Username: <?php echo htmlspecialchars($_SESSION['username']); ?></li>
                        <li>User Type: <?php echo ucfirst($_SESSION['user_type']); ?></li>
                    </ul>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html> 